#include "stdafx.h"
#include <iostream>
#include "Company.h"

using namespace std;

Company::Company() 
{}

Company::~Company() 
{}

void Company::AddOffice(Office o) 
{
	offices.push_back(o);
}

void Company::RemoveOffice(const string &city, const string &country) 
{
	for (list<Office>::iterator iter = offices.begin();
		 iter != offices.end(); 
		 iter++)
	{
		if (iter->GetCountry() == country && iter->GetCity() == city)
		{
			offices.erase(iter);
			break;
		}
	}
}

void Company::DisplayOffices() const
{
	for (list<Office>::const_iterator iter = offices.begin();
		 iter != offices.end(); 
		 iter++) 
	{
		cout << iter->ToString() << endl;
	}
}

void Company::DisplayEmployee(int id) 
{
	cout << employees[id].ToString() << endl;
}

void Company::AddEmployee(Employee e,int id)
{
	if (AlreadyExists(id))
	{
		cout << "id already exists!" << endl;
	}
	else
	{
		employees[id] = e;
	}
}

bool Company::AlreadyExists(int id) const
{
	return employees.find(id) != employees.end();
}

void Company::GivePayrise(int id, double amount)
{
	if (AlreadyExists(id))
	{
		employees[id].PayRise(amount);
	}
}